#include <stdio.h>
#include <stdlib.h>

int Uporedi(const void *a, const void *b) {
    long long val_a = *(const long long *)a;
    long long val_b = *(const long long *)b;
    
    if (val_a < val_b) return -1;
    if (val_a > val_b) return 1;
    return 0;
}

int main() {
    int N;
    if (scanf("%d", &N) != 1) return 1;

    long long *x = (long long *)malloc(N * sizeof(long long));
    long long *y = (long long *)malloc(N * sizeof(long long));
    long long *sum = (long long *)malloc(N * sizeof(long long)); 
    long long *raz = (long long *)malloc(N * sizeof(long long)); 

    if (!x || !y || !sum || !raz) {
        return 1;
    }

    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &x[i], &y[i]) != 2) return 1;
        sum[i] = x[i] + y[i];
        raz[i] = x[i] - y[i];
    }
    
    qsort(sum, N, sizeof(long long), Uporedi);
    qsort(raz, N, sizeof(long long), Uporedi);

    long long ukupno = 0;

    for (int i = 0; i < N; ) {
        int j = i;
        while (j < N && sum[j] == sum[i]) j++;
        long long br = j - i; 
        ukupno += br * (br - 1); 
        i = j;
    }

    for (int i = 0; i < N; ) {
        int j = i;
        while (j < N && raz[j] == raz[i]) j++;
        long long br = j - i; 
        ukupno += br * (br - 1); 
        i = j;
    }

    printf("%lld\n", ukupno);

    free(x);
    free(y);
    free(sum);
    free(raz);

    return 0;
}